<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('username', 120)->unique();
			$table->string('password', 120);
			$table->binary('name');
			$table->date('birthday');
			$table->enum('gender', array(''not_mention'', ''male'', ''female''));
			$table->binary('email');
			$table->string('phone', 30)->unique();
			$table->enum('show_tutorial', array('yes', 'no'));
			$table->string('picture', 200)->nullable();
			$table->enum('smoke', array('no', 'yes'));
			$table->binary('facebook_id')->nullable();
			$table->binary('google_id')->nullable();
			$table->integer('status_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}