<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('customers', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('status')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('clubs', function(Blueprint $table) {
			$table->foreign('satus_id')->references('id')->on('status')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_interests', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_interests', function(Blueprint $table) {
			$table->foreign('interests_id')->references('id')->on('interests')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('club_id')->references('id')->on('clubs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_interested_events', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_interested_events', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('club_id')->references('id')->on('clubs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('clubs_menus_items', function(Blueprint $table) {
			$table->foreign('club_id')->references('id')->on('clubs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('clubs_menus_items', function(Blueprint $table) {
			$table->foreign('clubs_menus_categries_items_id')->references('id')->on('clubs_menus_categries_items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('clubs_menus_items_prices', function(Blueprint $table) {
			$table->foreign('clubs_menus_item_id')->references('id')->on('clubs_menus_items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('checkins', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('checkins', function(Blueprint $table) {
			$table->foreign('club_id')->references('id')->on('clubs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('checkins', function(Blueprint $table) {
			$table->foreign('qrcode_id')->references('id')->on('qrcodes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('customers', function(Blueprint $table) {
			$table->dropForeign('customers_status_id_foreign');
		});
		Schema::table('clubs', function(Blueprint $table) {
			$table->dropForeign('clubs_satus_id_foreign');
		});
		Schema::table('users_interests', function(Blueprint $table) {
			$table->dropForeign('users_interests_customer_id_foreign');
		});
		Schema::table('users_interests', function(Blueprint $table) {
			$table->dropForeign('users_interests_interests_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_club_id_foreign');
		});
		Schema::table('users_interested_events', function(Blueprint $table) {
			$table->dropForeign('users_interested_events_user_id_foreign');
		});
		Schema::table('users_interested_events', function(Blueprint $table) {
			$table->dropForeign('users_interested_events_event_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_customer_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_club_id_foreign');
		});
		Schema::table('clubs_menus_items', function(Blueprint $table) {
			$table->dropForeign('clubs_menus_items_club_id_foreign');
		});
		Schema::table('clubs_menus_items', function(Blueprint $table) {
			$table->dropForeign('clubs_menus_items_clubs_menus_categries_items_id_foreign');
		});
		Schema::table('clubs_menus_items_prices', function(Blueprint $table) {
			$table->dropForeign('clubs_menus_items_prices_clubs_menus_item_id_foreign');
		});
		Schema::table('checkins', function(Blueprint $table) {
			$table->dropForeign('checkins_customer_id_foreign');
		});
		Schema::table('checkins', function(Blueprint $table) {
			$table->dropForeign('checkins_club_id_foreign');
		});
		Schema::table('checkins', function(Blueprint $table) {
			$table->dropForeign('checkins_qrcode_id_foreign');
		});
	}
}