<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClubsMenusItemsPricesTable extends Migration {

	public function up()
	{
		Schema::create('clubs_menus_items_prices', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('clubs_menus_item_id')->unsigned();
			$table->decimal('full_price', 8,3);
			$table->decimal('happy_hour_price', 8,3)->nullable();
			$table->string('universal_code')->nullable();
			$table->string('quantity');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('clubs_menus_items_prices');
	}
}