<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAnnounceTranslationTable extends Migration {

	public function up()
	{
		Schema::create('announce_translation', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('announce_id')->unsigned();
			$table->integer('language_id')->unsigned();
			$table->string('subject', 250);
			$table->string('subtitle', 250)->nullable();
			$table->text('content')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('announce_translation');
	}
}