<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingsTable extends Migration {

	public function up()
	{
		Schema::create('bookings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 250);
			$table->integer('country_id')->nullable();
			$table->integer('city_id')->nullable();
			$table->string('address', 500)->nullable();
			$table->string('logo', 250)->nullable();
			$table->integer('booking_type_id')->nullable();
			$table->integer('partner_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('bookings');
	}
}