<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderProductTable extends Migration {

	public function up()
	{
		Schema::create('order_product', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('order_id')->nullable();
			$table->integer('product_id')->nullable();
			$table->string('name', 250)->nullable();
			$table->string('model', 250)->nullable();
			$table->decimal('quantity', 15,4)->nullable();
			$table->decimal('price', 15,4)->nullable();
			$table->decimal('total', 15,4)->nullable();
			$table->decimal('tax', 15,4)->nullable();
			$table->integer('reward')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('order_product');
	}
}