<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductTable extends Migration {

	public function up()
	{
		Schema::create('product', function(Blueprint $table) {
			$table->increments('id', true);
			$table->timestamps();
			$table->string('model')->nullable();
			$table->string('location')->nullable();
			$table->integer('quantity')->nullable();
			$table->integer('stock_status_id')->nullable();
			$table->string('image')->nullable();
			$table->tinyInteger('shipping')->nullable();
			$table->decimal('price', 15,4)->nullable();
			$table->integer('points')->nullable();
			$table->integer('tax_class_id')->nullable();
			$table->date('date_available')->nullable();
			$table->decimal('weight', 8,4)->nullable();
			$table->integer('weight_class_id')->nullable();
			$table->decimal('length')->nullable();
			$table->integer('length_class_id')->nullable();
			$table->float('width')->nullable();
			$table->decimal('height')->nullable();
			$table->integer('minimum')->nullable();
			$table->tinyInteger('status')->nullable();
			$table->integer('viewed')->nullable();
			$table->integer('store_id')->nullable();
			$table->integer('supplier_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('product');
	}
}