<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTaxRateTable extends Migration {

	public function up()
	{
		Schema::create('tax_rate', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('city_id')->nullable();
			$table->string('name', 250)->nullable();
			$table->decimal('rate', 8,4)->nullable();
			$table->tinyInteger('type')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tax_rate');
	}
}