<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductOptionTable extends Migration {

	public function up()
	{
		Schema::create('product_option', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('product_id')->unsigned();
			$table->integer('option_id')->unsigned();
			$table->string('option_value')->nullable();
			$table->tinyInteger('required');
		});
	}

	public function down()
	{
		Schema::drop('product_option');
	}
}