<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEquipmentModelsTable extends Migration {

	public function up()
	{
		Schema::create('equipmentModels', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('equipmentid');
			$table->string('equipment_model_name', 255);
			$table->string('alias');
			$table->string('spec_path', 255);
			$table->tinyInteger('status');
			$table->softDeletes();
			$table->float('capacity');
			$table->integer('manufacturer');
		});
	}

	public function down()
	{
		Schema::drop('equipmentModels');
	}
}