<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCashBandsTable extends Migration {

	public function up()
	{
		Schema::create('cash_bands', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('slug')->nullable();
			$table->integer('cash_id')->unsigned()->nullable();
			$table->integer('cash_statement_id')->unsigned()->nullable();
			$table->string('quantity')->nullable();
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('cash_bands');
	}
}