<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReservationsTable extends Migration {

	public function up()
	{
		Schema::create('reservations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned();
			$table->integer('course_id')->unsigned();
			$table->integer('offers_details_id')->unsigned()->nullable();
			$table->float('price')->nullable()->default('0');
			$table->datetime('datetime')->nullable();
			$table->string('payment_method', 55)->nullable();
			$table->tinyInteger('is_paid')->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('reservations');
	}
}