<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('remember_token', 100)->nullable();
			$table->string('user_name', 100)->nullable();
			$table->string('full_name', 100)->nullable();
			$table->string('phone_number', 55)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('password', 255);
			$table->string('photo', 255)->nullable();
			$table->string('age', 55)->nullable();
			$table->string('bio', 255)->nullable();
			$table->string('address', 255)->nullable();
			$table->string('country', 55)->nullable();
			$table->string('state', 55)->nullable();
			$table->tinyInteger('is_verified')->nullable()->default('0');
			$table->string('token', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}