<?php

namespace Models/CourseLocations;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CourseLocations extends Model 
{

    protected $table = 'course_locations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function course()
    {
        return $this->belongsTo('Courses', 'course_id');
    }

    public function location()
    {
        return $this->hasOne('Locations', 'location_id');
    }

}