<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('course_instructors', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('course_instructors', function(Blueprint $table) {
			$table->foreign('instructor_id')->references('id')->on('instructors')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('course_locations', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('course_locations', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('media_categories')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('media_categories', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('media_categories')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('offers_details', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('offers_details', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offers')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('offers_details_id')->references('id')->on('offers_details')
						->onDelete('no action')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('course_instructors', function(Blueprint $table) {
			$table->dropForeign('course_instructors_course_id_foreign');
		});
		Schema::table('course_instructors', function(Blueprint $table) {
			$table->dropForeign('course_instructors_instructor_id_foreign');
		});
		Schema::table('course_locations', function(Blueprint $table) {
			$table->dropForeign('course_locations_course_id_foreign');
		});
		Schema::table('course_locations', function(Blueprint $table) {
			$table->dropForeign('course_locations_location_id_foreign');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->dropForeign('medias_category_id_foreign');
		});
		Schema::table('media_categories', function(Blueprint $table) {
			$table->dropForeign('media_categories_parent_id_foreign');
		});
		Schema::table('offers_details', function(Blueprint $table) {
			$table->dropForeign('offers_details_course_id_foreign');
		});
		Schema::table('offers_details', function(Blueprint $table) {
			$table->dropForeign('offers_details_offer_id_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_user_id_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_course_id_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_offers_details_id_foreign');
		});
	}
}