<?php

namespace Models/CourseInstructors;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CourseInstructors extends Eloquent {

	protected $table = 'course_instructors';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function course()
	{
		return $this->belongsTo('Courses', 'course_id');
	}

	public function instructor()
	{
		return $this->belongsTo('Instructors', 'instructor_id');
	}

}