<?php

namespace Models/OffersDetails;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OffersDetails extends Eloquent {

	protected $table = 'offers_details';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function course()
	{
		return $this->belongsTo('Courses', 'course_id');
	}

	public function offer()
	{
		return $this->belongsTo('Offers', 'offer_id');
	}

}