<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNewsTable extends Migration {

	public function up()
	{
		Schema::create('news', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 400)->nullable();
			$table->text('subject')->nullable();
			$table->datetime('datetime')->nullable();
			$table->string('cover', 400)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('news');
	}
}