<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDevicesTable extends Migration {

	public function up()
	{
		Schema::create('devices', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('device')->nullable();
			$table->string('token', 191)->nullable();
			$table->timestamps();
			$table->string('created_by');
			$table->string('updated_by');
		});
	}

	public function down()
	{
		Schema::drop('devices');
	}
}