<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Project extends Model 
{

    protected $table = 'projects';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function faq()
    {
        return $this->hasMany('Faq');
    }

    public function tickets()
    {
        return $this->hasMany('Ticket');
    }

    public function licenses()
    {
        return $this->hasMany('License');
    }

}