<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'date_of_birth', 'last_day_of_donation', 'city_id', 'phone_number', 'password');

	public function donationRquests()
	{
		return $this->hasMany('App\Models\DonationRequest');
	}

	public function city()
	{
		return $this->belongsTo('App\Models\City');
	}

	public function bloodtypes()
	{
		return $this->belongsToMany('App\Models\BloodType');
	}

	public function notifications()
	{
		return $this->hasMany('App\Models\Notification');
	}

	public function posts()
	{
		return $this->hasMany('App\Models\Post');
	}

}