<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class BidQuote extends Eloquent {

	protected $table = 'bidQuotes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function ticket()
	{
		return $this->belongsTo('Ticket', 'id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'id');
	}

	public function workorders()
	{
		return $this->hasOne('User', 'id');
	}

}