<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketLifeTable extends Migration {

	public function up()
	{
		Schema::create('ticketLife', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('ticketID')->unsigned();
			$table->integer('statusID')->default('0');
			$table->integer('userID')->unsigned();
			$table->string('comment')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('ticketLife');
	}
}