<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdvertisesTable extends Migration {

	public function up()
	{
		Schema::create('advertises', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('type', array('LINK', 'POST'))->index();
			$table->text('text');
			$table->text('media_ids');
			$table->text('description');
		});
	}

	public function down()
	{
		Schema::drop('advertises');
	}
}