<?php

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Document extends Eloquent {

	protected $table = 'documents';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function Customer()
	{
		return $this->belongsTo('Customer');
	}

	public function Activities()
	{
		return $this->morphMany('Activity', 'object');
	}

}