<?php

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Transaction extends Eloquent {

	protected $table = 'transactions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function Payments()
	{
		return $this->hasOne('Payment');
	}

	public function Loan()
	{
		return $this->belongsTo('Loan');
	}

}