<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('TeamPlayer', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('Player')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('TeamPlayer', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('Team')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('MatchPlayer', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('Team')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('MatchPlayer', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('Player')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('MatchLogs', function(Blueprint $table) {
			$table->foreign('match_id')->references('id')->on('Match')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('MatchLogs', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('Team')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('MatchLogs', function(Blueprint $table) {
			$table->foreign('player_1_id')->references('id')->on('Player')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('MatchLogs', function(Blueprint $table) {
			$table->foreign('player_2_id')->references('id')->on('Player')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('TeamPlayer', function(Blueprint $table) {
			$table->dropForeign('TeamPlayer_team_id_foreign');
		});
		Schema::table('TeamPlayer', function(Blueprint $table) {
			$table->dropForeign('TeamPlayer_player_id_foreign');
		});
		Schema::table('MatchPlayer', function(Blueprint $table) {
			$table->dropForeign('MatchPlayer_team_id_foreign');
		});
		Schema::table('MatchPlayer', function(Blueprint $table) {
			$table->dropForeign('MatchPlayer_player_id_foreign');
		});
		Schema::table('MatchLogs', function(Blueprint $table) {
			$table->dropForeign('MatchLogs_match_id_foreign');
		});
		Schema::table('MatchLogs', function(Blueprint $table) {
			$table->dropForeign('MatchLogs_team_id_foreign');
		});
		Schema::table('MatchLogs', function(Blueprint $table) {
			$table->dropForeign('MatchLogs_player_1_id_foreign');
		});
		Schema::table('MatchLogs', function(Blueprint $table) {
			$table->dropForeign('MatchLogs_player_2_id_foreign');
		});
	}
}