<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyDaysWorkTable extends Migration {

	public function up()
	{
		Schema::create('Company_days_work', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('company_id');
			$table->bigInteger('branch_id');
			$table->enum('day', array('saturday', 'sunday', 'monday', 'tuesday', 'wednesday', 'thursday', 'friday'));
			$table->string('start_time', 10);
			$table->softDeletes();
			$table->timestamps();
			$table->string('end_time', 10);
		});
	}

	public function down()
	{
		Schema::drop('Company_days_work');
	}
}