<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobsTable extends Migration {

	public function up()
	{
		Schema::create('jobs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('re_user_id')->unsigned()->nullable();
			$table->integer('category_id')->unsigned();
			$table->string('voice_gender', 255)->nullable();
			$table->integer('language_id')->unsigned();
			$table->integer('accent_id')->unsigned();
			$table->string('no_of_words', 20)->nullable();
			$table->double('cost_from', 10,2)->default('0');
			$table->double('cost_to', 10,2)->default('0');
			$table->date('deadline_date')->nullable();
			$table->datetime('deadline_time')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('jobs');
	}
}