<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('fl_details', function(Blueprint $table) {
			$table->foreign('age_category_id')->references('id')->on('age_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fl_details', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fl_details', function(Blueprint $table) {
			$table->foreign('accent_id')->references('id')->on('accents')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fl_details', function(Blueprint $table) {
			$table->foreign('experience_level_id')->references('id')->on('experience_levels')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fl_job_categories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fl_voice_samples', function(Blueprint $table) {
			$table->foreign('fl_job_category_id')->references('id')->on('fl_job_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fl_directed_sessions', function(Blueprint $table) {
			$table->foreign('directed_session_id')->references('id')->on('directed_sessions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->foreign('accent_id')->references('id')->on('accents')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('job_age_categories', function(Blueprint $table) {
			$table->foreign('job_id')->references('id')->on('jobs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('job_age_categories', function(Blueprint $table) {
			$table->foreign('age_category_id')->references('id')->on('age_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('job_experiences', function(Blueprint $table) {
			$table->foreign('job_id')->references('id')->on('jobs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('job_experiences', function(Blueprint $table) {
			$table->foreign('experience_level_id')->references('id')->on('experience_levels')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('fl_details', function(Blueprint $table) {
			$table->dropForeign('fl_details_age_category_id_foreign');
		});
		Schema::table('fl_details', function(Blueprint $table) {
			$table->dropForeign('fl_details_language_id_foreign');
		});
		Schema::table('fl_details', function(Blueprint $table) {
			$table->dropForeign('fl_details_accent_id_foreign');
		});
		Schema::table('fl_details', function(Blueprint $table) {
			$table->dropForeign('fl_details_experience_level_id_foreign');
		});
		Schema::table('fl_job_categories', function(Blueprint $table) {
			$table->dropForeign('fl_job_categories_category_id_foreign');
		});
		Schema::table('fl_voice_samples', function(Blueprint $table) {
			$table->dropForeign('fl_voice_samples_fl_job_category_id_foreign');
		});
		Schema::table('fl_directed_sessions', function(Blueprint $table) {
			$table->dropForeign('fl_directed_sessions_directed_session_id_foreign');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->dropForeign('jobs_category_id_foreign');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->dropForeign('jobs_language_id_foreign');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->dropForeign('jobs_accent_id_foreign');
		});
		Schema::table('job_age_categories', function(Blueprint $table) {
			$table->dropForeign('job_age_categories_job_id_foreign');
		});
		Schema::table('job_age_categories', function(Blueprint $table) {
			$table->dropForeign('job_age_categories_age_category_id_foreign');
		});
		Schema::table('job_experiences', function(Blueprint $table) {
			$table->dropForeign('job_experiences_job_id_foreign');
		});
		Schema::table('job_experiences', function(Blueprint $table) {
			$table->dropForeign('job_experiences_experience_level_id_foreign');
		});
	}
}