<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class DirectedSession extends Eloquent {

	protected $table = 'directed_sessions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'status');

	public function freelanceDirectedSession()
	{
		return $this->hasMany('App\Models\DirectedSession');
	}

}