<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Job extends Eloquent {

	protected $table = 'jobs';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('re_user_id', 'category_id', 'voice_gender', 'language_id', 'accent_id', 'no_of_words', 'cost_from', 'cost_to', 'deadline_date', 'deadline_time');

	public function category()
	{
		return $this->belongsTo('App\Models\Category', 'category_id', 'id');
	}

	public function accent()
	{
		return $this->belongsTo('App\Models\Accent', 'accent_id', 'id');
	}

	public function language()
	{
		return $this->belongsTo('App\Models\Language', 'language_id', 'id');
	}

}