<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('email', 255);
			$table->string('password');
			$table->string('image');
			$table->integer('type_account');
			$table->string('payfort');
			$table->string('paytabs');
			$table->integer('admin_add');
			$table->integer('admin_update');
			$table->integer('admin_delete');
			$table->enum('delete_status', array('0', '1'));
			$table->timestamps();
			$table->enum('status', array('0', '1'));
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}