<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePageTemplatesTable extends Migration {

	public function up()
	{
		Schema::create('page_templates', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('site_user_id')->unsigned()->index();
			$table->string('name');
			$table->text('description')->nullable();
			$table->string('status')->default('draft');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('page_templates');
	}
}