<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSiteThemesTable extends Migration {

	public function up()
	{
		Schema::create('site_themes', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('site_id')->unsigned()->index();
			$table->integer('theme_id')->unsigned()->nullable()->index();
			$table->integer('site_user_id')->unsigned()->index();
			$table->string('name')->index();
			$table->text('description')->nullable();
			$table->longText('settings');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('site_themes');
	}
}