<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSiteUsersTable extends Migration {

	public function up()
	{
		Schema::create('site_users', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('site_id')->unsigned()->index();
			$table->string('email')->index();
			$table->string('username')->nullable()->index();
			$table->string('password');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('site_users');
	}
}