<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 200);
			$table->string('email', 200)->unique();
			$table->integer('role_id')->unsigned();
			$table->string('password', 200);
			$table->boolean('is_active')->default(1);
			$table->boolean('is_admin')->default(0);
			$table->datetime('create_at');
			$table->datetime('update_at')->nullable();
			$table->integer('create_by')->unsigned();
			$table->integer('update_by')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}