<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReceiptsTable extends Migration {

	public function up()
	{
		Schema::create('receipts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('customer_service_id')->unsigned();
			$table->longText('description')->nullable();
			$table->boolean('is_paid')->default(0);
			$table->datetime('create_at');
		});
	}

	public function down()
	{
		Schema::drop('receipts');
	}
}