<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArticlesTable extends Migration {

	public function up()
	{
		Schema::create('articles', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 255);
			$table->string('date', 255);
			$table->text('details');
			$table->string('writer', 255);
			$table->string('img_url', 255);
			$table->string('slug', 191)->unique();
			$table->integer('admin_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('articles');
	}
}