<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateScholarshipsTable extends Migration {

	public function up()
	{
		Schema::create('scholarships', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('email', 191);
			$table->timestamps();
			$table->string('degree_type', 255);
			$table->string('rule', 191);
			$table->longText('breif');
			$table->string('is_regular_or_not', 191);
			$table->integer('city_id')->unsigned();
			$table->integer('admin_id')->unsigned();
			$table->text('is_allowed');
		});
	}

	public function down()
	{
		Schema::drop('scholarships');
	}
}