<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRawDataTable extends Migration {

	public function up()
	{
		Schema::create('raw_data', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('refKit');
			$table->float('level_drt');
			$table->integer('level_mrc');
			$table->float('temperature');
			$table->float('env_temperature')->nullable();
			$table->float('current')->nullable();
			$table->float('density')->nullable();
			$table->string('date_time')->nullable();
			$table->float('pressure')->nullable();
			$table->float('depotage')->nullable();
			$table->string('raw_data')->nullable();
			$table->boolean('is_depotage')->nullable();
			$table->float('current_value')->nullable();
			$table->float('value_to_store')->nullable();
			$table->float('f1')->nullable();
			$table->float('f2')->nullable();
			$table->integer('dep')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('raw_data');
	}
}