<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('service_stations', function(Blueprint $table) {
			$table->foreign('town_id')->references('id')->on('towns')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('company_user_service_stations', function(Blueprint $table) {
			$table->foreign('service_station_id')->references('id')->on('service_stations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('company_user_service_stations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('company_user_service_stations', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('towns', function(Blueprint $table) {
			$table->foreign('region_id')->references('id')->on('regions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_station_tanks', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_station_tanks', function(Blueprint $table) {
			$table->foreign('service_station_id')->references('id')->on('service_stations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tanks', function(Blueprint $table) {
			$table->foreign('product_station_tank_id')->references('id')->on('product_station_tanks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tanks', function(Blueprint $table) {
			$table->foreign('jauge_id')->references('id')->on('jauges')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('depotages', function(Blueprint $table) {
			$table->foreign('tank_id')->references('id')->on('tanks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('quart_workings', function(Blueprint $table) {
			$table->foreign('service_station_id')->references('id')->on('service_stations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('remaining_notification_parameters', function(Blueprint $table) {
			$table->foreign('service_station_id')->references('id')->on('service_stations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('records', function(Blueprint $table) {
			$table->foreign('tank_id')->references('id')->on('tanks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('correction_data', function(Blueprint $table) {
			$table->foreign('tank_id')->references('id')->on('tanks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('tank_id')->references('id')->on('tanks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('type_notification_id')->references('id')->on('type_notifications')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('company_user_service_station_id')->references('id')->on('company_user_service_stations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_loggings', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('service_stations', function(Blueprint $table) {
			$table->dropForeign('service_stations_town_id_foreign');
		});
		Schema::table('company_user_service_stations', function(Blueprint $table) {
			$table->dropForeign('company_user_service_stations_service_station_id_foreign');
		});
		Schema::table('company_user_service_stations', function(Blueprint $table) {
			$table->dropForeign('company_user_service_stations_user_id_foreign');
		});
		Schema::table('company_user_service_stations', function(Blueprint $table) {
			$table->dropForeign('company_user_service_stations_company_id_foreign');
		});
		Schema::table('towns', function(Blueprint $table) {
			$table->dropForeign('towns_region_id_foreign');
		});
		Schema::table('product_station_tanks', function(Blueprint $table) {
			$table->dropForeign('product_station_tanks_product_id_foreign');
		});
		Schema::table('product_station_tanks', function(Blueprint $table) {
			$table->dropForeign('product_station_tanks_service_station_id_foreign');
		});
		Schema::table('tanks', function(Blueprint $table) {
			$table->dropForeign('tanks_product_station_tank_id_foreign');
		});
		Schema::table('tanks', function(Blueprint $table) {
			$table->dropForeign('tanks_jauge_id_foreign');
		});
		Schema::table('depotages', function(Blueprint $table) {
			$table->dropForeign('depotages_tank_id_foreign');
		});
		Schema::table('quart_workings', function(Blueprint $table) {
			$table->dropForeign('quart_workings_service_station_id_foreign');
		});
		Schema::table('remaining_notification_parameters', function(Blueprint $table) {
			$table->dropForeign('remaining_notification_parameters_service_station_id_foreign');
		});
		Schema::table('records', function(Blueprint $table) {
			$table->dropForeign('records_tank_id_foreign');
		});
		Schema::table('correction_data', function(Blueprint $table) {
			$table->dropForeign('correction_data_tank_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_tank_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_type_notification_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_company_user_service_station_id_foreign');
		});
		Schema::table('user_loggings', function(Blueprint $table) {
			$table->dropForeign('user_loggings_user_id_foreign');
		});
	}
}