<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Company extends Eloquent {

	protected $table = 'companies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('address', 'name', 'phone', 'website', 'logo', 'start_date', 'expected_end_date', 'email');
	protected $visible = array('address', 'name', 'phone', 'website', 'logo', 'start_date', 'expected_end_date', 'email');

	public function company_user_service_stations()
	{
		return $this->hasMany('CompanyUserServiceStation');
	}

}