<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('code', 'name', 'price');
	protected $visible = array('code', 'name', 'price');

	public function product_station_tanks()
	{
		return $this->hasMany('ProductStationTank');
	}

}