<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Town extends Eloquent {

	protected $table = 'towns';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'region_id');
	protected $visible = array('name', 'region_id');

	public function stationsServices()
	{
		return $this->hasMany('ServiceStation');
	}

	public function region()
	{
		return $this->belongsTo('Region', 'region_id');
	}

}