<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProbeSensorsTable extends Migration {

	public function up()
	{
		Schema::create('probe_sensors', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('sensor_ref')->nullable();
			$table->float('density_up')->nullable();
			$table->float('density_down')->nullable();
			$table->float('temperature_down')->nullable();
			$table->float('level_up')->nullable();
			$table->float('level_down')->nullable();
			$table->float('pressure_up')->nullable();
			$table->float('pressure_down')->nullable();
			$table->string('hourkit')->nullable();
			$table->float('temperature_up')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('probe_sensors');
	}
}