<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('adress')->nullable();
			$table->string('profil_image')->nullable();
			$table->string('email')->unique();
			$table->string('first_name');
			$table->string('last_name');
			$table->string('password');
			$table->integer('phone')->nullable();
			$table->boolean('status')->default(true);
			$table->string('token')->nullable();
			$table->boolean('is_confirm')->default(false);
			$table->string('private_mail')->unique()->nullable();
			$table->boolean('is_first_conn')->default(false);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}