<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->tinyInteger('is_verified')->nullable();
			$table->string('first_name', 255)->nullable();
			$table->string('last_name', 255)->nullable();
			$table->integer('language_id')->nullable();
			$table->string('email', 255)->nullable();
			$table->string('password', 255)->nullable();
			$table->string('phone_code', 255);
			$table->string('phone_number', 100)->nullable();
			$table->tinyInteger('is_active')->nullable();
			$table->string('remember_token', 100)->nullable();
			$table->timestamps();
			$table->string('date_format', 255)->nullable();
			$table->softDeletes();
			$table->timestamps();
			$table->tinyInteger('is_2fa_active')->nullable();
			$table->text('avatar')->nullable();
			$table->string('time_format', 255)->nullable();
			$table->string('connected_email', 255)->nullable();
			$table->text('connected_email_token')->nullable();
			$table->string('connected_email_alias', 255)->nullable();
			$table->text('connected_email_signature')->nullable();
			$table->tinyInteger('unsubscribe_type')->nullable();
			$table->tinyInteger('is_unsubscribe')->nullable();
			$table->string('whatsapp_number', 255)->nullable();
			$table->string('verified_code', 255)->nullable();
			$table->timestamp('verified_expires_at')->nullable();
			$table->tinyInteger('type_2fa')->nullable();
			$table->text('google_secret')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}