<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLabelsTable extends Migration {

	public function up()
	{
		Schema::create('labels', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('account_id')->nullable();
			$table->bigInteger('association_type_id')->nullable();
			$table->string('name', 255)->nullable();
			$table->integer('limit')->nullable();
			$table->string('from_object_name', 255)->nullable();
			$table->string('to_object_name', 255)->nullable();
			$table->integer('created_by')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('labels');
	}
}