<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertyValuesTable extends Migration {

	public function up()
	{
		Schema::create('property_values', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('property_id')->nullable();
			$table->integer('account_id')->nullable();
			$table->integer('property_type')->nullable();
			$table->integer('position')->nullable();
			$table->string('key', 255)->nullable();
			$table->string('value', 255)->nullable();
			$table->string('type_element', 255)->nullable();
			$table->tinyInteger('in_form')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('property_values');
	}
}